#include "StdAfx.h"
#include "wii.h"

#pragma comment(lib, "./control/wii/hid.lib")

#pragma comment(lib, "./control/wii/WiiYourself!_d.lib")

// ------------------------------------------------------------------------------------
//  simple callback example (we use polling for everything else):
// ------------------------------------------------------------------------------------
void on_state_change (wiimote &wiimote, state_change_flags changed)
	{
	// extension was just connected:
	if(changed & (NUNCHUK_CONNECTED|CLASSIC_CONNECTED))
		{
		//Beep(1000, 200);
		// switch to a report mode that includes the extension data (we will
		//  loose the IR dot sizes)
		wiimote.SetReportType(wiimote::IN_BUTTONS_ACCEL_IR_EXT);
		}
	// extension was just disconnected:
	else if(changed & EXTENSION_DISCONNECTED)
		{
		//Beep(200, 300);
		// use a non-extension report mode (this gives us back the IR dot sizes)
		wiimote.SetReportType(wiimote::IN_BUTTONS_ACCEL_IR);
		}
	}

wii::wii(void)
{
	first=true;	
}

wii::~wii(void)
{
	wiimote.Disconnect();
}

int wii::startwiimote()
{
	if (first)
	{
	initfilter();
    // simple callback example (we use polling for almost everything here):
	//  notify us when something related to the extension changes
	wiimote.ChangedCallback		 = on_state_change;
	//  avoid unwanted callback overhead by requesting only extension-related data
	wiimote.CallbackTriggerFlags = EXTENSION_CHANGED;
	RcvThreadRun=false;	
	AfxBeginThread(RcvThread,this);	
	RcvThreadRun=true;
	wiix=0;
	wiiy=0;
	first=false;
	}
return 1;
}

int wii::stopwiimote()
{
	RcvThreadRun=false;
	wiix=0;
	wiiy=0;
	first=true;
	wiimote.Disconnect();
return 1;
}

CPoint wii::GetWiiVal(void)
{
	CPoint tmp;
	WiiMutex.acquire();
	tmp.x=wiix;
    tmp.y=wiiy;
	WiiMutex.release();
return tmp;
}

void wii::RcvThread(void)
{
	reconnect:
	printf("  Looking for a Wiimote \n    ");
	   
	static const TCHAR* wait_str[] = { _T(".  "), _T(".. "), _T("...") };
	unsigned count = 0;
	while((!wiimote.Connect(wiimote::FIRST_AVAILABLE))&&(RcvThreadRun)) {
		_tprintf(_T("\b\b\b\b%s "), wait_str[count%3]);
		count++;
		//Beep(500, 30); Sleep(1000);
		}
if (RcvThreadRun)
{
	// connected - light all LEDs
	wiimote.SetLEDs(0x0f);
	_tprintf(_T("\b\b\b\b... connected! \n"));
	//Beep(1000, 300); Sleep(2000);

	// ask the wiimote to report everything (using the 'non-continous updates'
	//  default mode - updates will be frequent anyway due to the acceleration/IR
	//  values changing):

	// *note*: the report mode that includes the extension data unfortunately
	//			only reports the 'BASIC' IR info (ie. no dot sizes) - so let's choose
	//          the best mode based on the extension status (we also toggle modes
	//			as needed in the callback above):
	if(wiimote.bExtension)
		wiimote.SetReportType(wiimote::IN_BUTTONS_ACCEL_IR_EXT); // no IR dots
	else
		wiimote.SetReportType(wiimote::IN_BUTTONS_ACCEL_IR);	 //    IR dots

	// print the button event instructions:

	_tprintf(_T("\r  -- TRY: B = rumble, A = square, 1 = sine, 2 = daisy, Home = Exit --\n"));

	// (stuff for animations)
	last_rumble_time = timeGetTime(); // for rumble text animation
	last_led_time    = timeGetTime(); // for led         animation
	rumble_text	  = true;
	lit_led          = 0;	
}	
/////////////////////////////////////////////////////
// display the wiimote state data (until 'Home' is pressed):
	while(RcvThreadRun)
		{
		// the wiimote state needs to be refreshed for each pass
		while(wiimote.RefreshState() == NO_CHANGE)
			Sleep(1); // // don't hog the CPU if nothing changed

		// did we loose the connection?
		if(wiimote.ConnectionLost())
			{
			_tprintf(_T("   *** connection lost! ***\n"));
			//Beep(100, 1000);
			Sleep(2000);
			_tprintf("\n");
			wiix=0;
			wiiy=0;
			goto reconnect;
			}
		
		DWORD current_time = timeGetTime();
		// LEDs:
		//  animate them every second
		if((current_time - last_led_time) >= 1000) {
			wiimote.SetLEDs(1<<lit_led);
			lit_led		  = (++lit_led) % 4;
			last_led_time = timeGetTime();
			}
		// End LED

		// Buttons:
		
		for(unsigned bit=0; bit<16; bit++)
			{
			WORD mask = 1 << bit;
			// skip unused bits
			if((wiimote_state::buttons::ALL & mask) == 0)
				continue;

			const TCHAR* button_name = wiimote::ButtonNameFromBit[bit];
			bool		 pressed	 = ((wiimote.Button.Bits & mask) != 0);
			if(bit > 0) {
				//_tprintf(_T("|")); // seperator
				}
			if(pressed) {
				//_tprintf(_T("%s")  , button_name);
				}
			else{
				//_tprintf(_T("% *s"), _tcslen(button_name), _T(""));
				}
			}
		//_tprintf(_T("]\n"));

		/*_tprintf(_T("  X %+2.3f  Y %+2.3f  Z %+2.3f  \n"),
						wiimote.Acceleration.X,
						wiimote.Acceleration.Y,
						wiimote.Acceleration.Z);
		*/
		if (wiimote.Button.B())
		{
			WiiMutex.acquire();
			float tmpx = wiimote.Acceleration.X*100;//data to filter				
			wiix = ((int)iir_filter(tmpx,&iir1))/2;
			float tmpy = wiimote.Acceleration.Y*100;//data to filter				
			wiiy = -((int)iir_filter(tmpy,&iir2))/2;
			if ((wiiy<8)&&(wiiy>-8)) wiiy=0;			
     		WiiMutex.release();
		}
		else
		{
			WiiMutex.acquire();
			wiix=0;wiiy=0;
			WiiMutex.release();			
		}
		/*_tprintf(_T("  X %+2.3f  Y %+2.3f  Z %+2.3f  \n"),
						wiix,
						wiiy,
						wiimote.Acceleration.Z);*/
	/*
		// Orientation estimate (shown red if last valid update is aging):
		_tprintf(_T("   Orient:"));
		_tprintf(_T("  UpdateAge % 3u  "),
						wiimote.Acceleration.Orientation.UpdateAge);
		*/
		//  show if the last orientation update is considered out-of-date
		//   (using an arbitrary threshold)
	/*	if(wiimote.Acceleration.Orientation.UpdateAge > 10)
			
			
		_tprintf(_T("Pitch % 4ddeg  Roll % 4ddeg  \n")
			     _T("                           (X %+.3f  Y %+.3f  Z %+.3f)      \n"),
				(int)wiimote.Acceleration.Orientation.Pitch,
				(int)wiimote.Acceleration.Orientation.Roll ,
				wiimote.Acceleration.Orientation.X,
				wiimote.Acceleration.Orientation.Y,
  				wiimote.Acceleration.Orientation.Z);*/

//runfilter();
		
Sleep(50);
	}
////////////////////////////////////////////////////
}

UINT wii::RcvThread(LPVOID p)
{
   wii *me = (wii *)p;
   me->RcvThread();
   return 0;
}

/*
 * --------------------------------------------------------------------
 * 
 * iir_filter - Perform IIR filtering sample by sample on floats
 * 
 * Implements cascaded direct form II second order sections.
 * Requires FILTER structure for history and coefficients.
 * The length in the filter structure specifies the number of sections.
 * The size of the history array is 2*iir->length.
 * The size of the coefficient array is 4*iir->length + 1 because
 * the first coefficient is the overall scale factor for the filter.
 * Returns one output sample for each input sample.  Allocates history
 * array if not previously allocated.
 * 
 * float iir_filter(float input,FILTER *iir)
 * 
 *     float input        new float input sample
 *     FILTER *iir        pointer to FILTER structure
 * 
 * Returns float value giving the current output.
 * 
 * Allocation errors cause an error message and a call to exit.
 * --------------------------------------------------------------------
 */
float wii::iir_filter(float input,FILTER *iir)
           /* new input sample */
            /* pointer to FILTER structure */
{
    unsigned int i;
    float *hist1_ptr,*hist2_ptr,*coef_ptr;
    float output,new_hist,history1,history2;

/* allocate history array if different size than last call */

    if(!iir->history) {
        iir->history = (float *) calloc(2*iir->length,sizeof(float));
        if(!iir->history) {
            printf("\nUnable to allocate history array in iir_filter\n");
            exit(1);
        }
    }

    coef_ptr = iir->coef;                /* coefficient pointer */

    hist1_ptr = iir->history;            /* first history */
    hist2_ptr = hist1_ptr + 1;           /* next history */

        /* 1st number of coefficients array is overall input scale factor,
         * or filter gain */
    output = input * (*coef_ptr++);

    for (i = 0 ; i < iir->length; i++)
        {
        history1 = *hist1_ptr;           /* history values */
        history2 = *hist2_ptr;

        output = output - history1 * (*coef_ptr++);
        new_hist = output - history2 * (*coef_ptr++);    /* poles */

        output = new_hist + history1 * (*coef_ptr++);
        output = output + history2 * (*coef_ptr++);      /* zeros */

        *hist2_ptr++ = *hist1_ptr;
        *hist1_ptr++ = new_hist;
        hist1_ptr++;
        hist2_ptr++;
    }

    return(output);
}



/*
 * ----------------------------------------------------------
 * bilinear()
 *
 * Transform the numerator and denominator coefficients
 * of s-domain biquad section into corresponding
 * z-domain coefficients.
 *
 *      Store the 4 IIR coefficients in array pointed by coef
 *      in following order:
 *             beta1, beta2    (denominator)
 *             alpha1, alpha2  (numerator)
 *
 * Arguments:
 *             a0-a2   - s-domain numerator coefficients
 *             b0-b2   - s-domain denominator coefficients
 *             k               - filter gain factor. initially set to 1
 *                                and modified by each biquad section in such
 *                                a way, as to make it the coefficient by
 *                                which to multiply the overall filter gain
 *                                in order to achieve a desired overall filter gain,
 *                                specified in initial value of k.
 *             fs             - sampling rate (Hz)
 *             coef    - array of z-domain coefficients to be filled in.
 *
 * Return:
 *             On return, set coef z-domain coefficients
 * ----------------------------------------------------------
 */
void wii::bilinear(
    double a0, double a1, double a2,    /* numerator coefficients */
    double b0, double b1, double b2,    /* denominator coefficients */
    double *k,           /* overall gain factor */
    double fs,           /* sampling rate */
    float *coef         /* pointer to 4 iir coefficients */
)
{
    double ad, bd;

                 /* alpha (Numerator in s-domain) */
    ad = 4. * a2 * fs * fs + 2. * a1 * fs + a0;
                 /* beta (Denominator in s-domain) */
    bd = 4. * b2 * fs * fs + 2. * b1* fs + b0;

                 /* update gain constant for this section */
    *k *= ad/bd;

                 /* Denominator */
    *coef++ = (2. * b0 - 8. * b2 * fs * fs)/ bd;         /* beta1 */
    *coef++ = (4. * b2 * fs * fs - 2. * b1 * fs + b0) / bd; /* beta2 */

                 /* Nominator */
    *coef++ = (2. * a0 - 8. * a2 * fs * fs) / ad;         /* alpha1 */
    *coef = (4. * a2 * fs * fs - 2. * a1 * fs + a0) / ad;   /* alpha2 */
}


/*
 * ----------------------------------------------------------
 * Transform from s to z domain using bilinear transform
 * with prewarp.
 *
 * Arguments:
 *      For argument description look at bilinear()
 *
 *      coef - pointer to array of floating point coefficients,
 *                     corresponding to output of bilinear transofrm
 *                     (z domain).
 *
 * Note: frequencies are in Hz.
 * ----------------------------------------------------------
 */
void wii::szxform(
    double *a0, double *a1, double *a2, /* numerator coefficients */
    double *b0, double *b1, double *b2, /* denominator coefficients */
    double fc,         /* Filter cutoff frequency */
    double fs,         /* sampling rate */
    double *k,         /* overall gain factor */
    float *coef)         /* pointer to 4 iir coefficients */
{
                 /* Calculate a1 and a2 and overwrite the original values */
        prewarp(a0, a1, a2, fc, fs);
        prewarp(b0, b1, b2, fc, fs);
        bilinear(*a0, *a1, *a2, *b0, *b1, *b2, k, fs, coef);
}


/*
 * ----------------------------------------------------------
 *      Pre-warp the coefficients of a numerator or denominator.
 *      Note that a0 is assumed to be 1, so there is no wrapping
 *      of it.
 * ----------------------------------------------------------
 */
void wii::prewarp(double *a0, double *a1, double *a2,double fc, double fs)
{
    double wp;//, pi;

    //pi = 4.0 * atan(1.0);
    wp = 2.0 * fs * tan(pi * fc / fs);

    *a2 = (*a2) / (wp * wp);
    *a1 = (*a1) / wp;
}

int wii::initfilter()
{
		/*
 * Setup filter s-domain coefficients
 */
                 /* Section 1 */       
        ProtoCoef[0].a0 = 1.0;
        ProtoCoef[0].a1 = 0;
        ProtoCoef[0].a2 = 0;
        ProtoCoef[0].b0 = 1.0;
        ProtoCoef[0].b1 = 2.765367;
        ProtoCoef[0].b2 = 1.0;

                 /* Section 2 */       
        ProtoCoef[1].a0 = 1.0;
        ProtoCoef[1].a1 = 0;
        ProtoCoef[1].a2 = 0;
        ProtoCoef[1].b0 = 1.0;
        ProtoCoef[1].b1 = 3.847759;
        ProtoCoef[1].b2 = 1.0;
/*
               //Section        
        ProtoCoef[0].a0_2 = 1.0;
        ProtoCoef[0].a1_2 = 0;
        ProtoCoef[0].a2_2 = 0;
        ProtoCoef[0].b0_2 = 1.0;
        ProtoCoef[0].b1_2 = 2.765367;
        ProtoCoef[0].b2_2 = 1.0;

  //                Section 2        
        ProtoCoef[1].a0_2 = 1.0;
        ProtoCoef[1].a1_2 = 0;
        ProtoCoef[1].a2_2 = 0;
        ProtoCoef[1].b0_2 = 1.0;
        ProtoCoef[1].b1_2 = 3.847759;
        ProtoCoef[1].b2_2 = 1.0;
*/

        iir1.length = FILTER_SECTIONS;         /* Number of filter sections */
		iir2.length = FILTER_SECTIONS;         /* Number of filter sections */

			/*
 * Allocate array of z-domain coefficients for each filter section
 * plus filter gain variable
 */
        iir1.coef = (float *) calloc(4 * iir1.length + 1, sizeof(float));
        if (!iir1.coef)
        {
                 printf("Unable to allocate coef1 array, exiting\n");
                 exit(1);
        }
		
		iir2.coef = (float *) calloc(4 * iir2.length + 1, sizeof(float));
        if (!iir2.coef)
        {
                 printf("Unable to allocate coef2 array, exiting\n");
                 exit(1);
        }

        k1 = 1.0;          /* Set overall filter gain */
        coef1 = iir1.coef + 1;     /* Skip k, or gain */
        Q1 = 1;                         /* Resonance */
        fc1 = 10;                  /* Filter cutoff (Hz) */
        fs1 = 50;                      /* Sampling frequency (Hz) */

		k2 = 1.0;          /* Set overall filter gain */
        coef2 = iir2.coef + 1;     /* Skip k, or gain */
        Q2 = 1;                         /* Resonance */
        fc2 = 10;                  /* Filter cutoff (Hz) */
        fs2 = 50;                      /* Sampling frequency (Hz) */

/*
 * Compute z-domain coefficients for each biquad section
 * for new Cutoff Frequency and Resonance
 */
        for (nInd1 = 0; nInd1 < iir1.length; nInd1++)
        {
                 a0_1 = ProtoCoef[nInd1].a0;
                 a1_1 = ProtoCoef[nInd1].a1;
                 a2_1 = ProtoCoef[nInd1].a2;

                 b0_1 = ProtoCoef[nInd1].b0;
                 b1_1 = ProtoCoef[nInd1].b1 / Q1;      /* Divide by resonance or Q */
                 b2_1 = ProtoCoef[nInd1].b2;
                 szxform(&a0_1, &a1_1, &a2_1, &b0_1, &b1_1, &b2_1, fc1, fs1, &k1, coef1);
                 coef1 += 4;                       /* Point to next filter section */
        }

		 for (nInd2 = 0; nInd2 < iir2.length; nInd2++)
        {
                 a0_2 = ProtoCoef[nInd2].a0;
                 a1_2 = ProtoCoef[nInd2].a1;
                 a2_2 = ProtoCoef[nInd2].a2;

                 b0_2 = ProtoCoef[nInd2].b0;
                 b1_2 = ProtoCoef[nInd2].b1 / Q2;      /* Divide by resonance or Q */
                 b2_2 = ProtoCoef[nInd2].b2;
                 szxform(&a0_2, &a1_2, &a2_2, &b0_2, &b1_2, &b2_2, fc2, fs2, &k2, coef2);
                 coef2 += 4;                       /* Point to next filter section */
        }

        /* Update overall filter gain in coef array */
        iir1.coef[0] = k1;
		iir2.coef[0] = k2;

        /* Display filter coefficients */
        for (nInd1 = 0; nInd1 < (iir1.length * 4 + 1); nInd1++)
                 printf("C[%d] = %15.10f\n", nInd1, iir1.coef[nInd1]);
		for (nInd2 = 0; nInd2 < (iir2.length * 4 + 1); nInd2++)
                 printf("C[%d] = %15.10f\n", nInd2, iir2.coef[nInd2]);
}

int wii::runfilter()
{
			/*
		 * To process audio samples, call function iir_filter()
		 * for each audio sample
		 */
		///////////////////////////////////////////////////////////////////////////::::
		///////////////////////////////////////////////////////////////////////////::::
		//while(1)
		float tmpx = 1000;//data to filter
				
		int tmpix = ((int)iir_filter(tmpx,&iir1))/10;
		
		if (tmpix >50) tmpix=50;
		if (tmpix <-50) tmpix=-50;
		
        float tmpy = 1200;//data to filter
				
		int tmpiy = ((int)iir_filter(tmpy,&iir2))/10;
		
		if (tmpiy>50) tmpiy=50;
		if (tmpiy <-50) tmpiy=-50;
		//end while(1)
		///////////////////////////////////////////////////////////////////////////::::
		///////////////////////////////////////////////////////////////////////////::::
return 1;
}
